/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NBTTags;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.event.BlockEvent;
import noppes.npcs.api.event.CustomNPCsEvent;
import noppes.npcs.api.event.ForgeEvent;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class BaseScriptData
implements IScriptHandler {
    protected boolean enabled = false;
    public boolean hadInteract = true;
    public long lastInited = -1L;
    protected String scriptLanguage = "ECMAScript";
    protected List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();

    public void clear() {
        this.scripts = new ArrayList<ScriptContainer>();
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    @Override
    public TreeMap<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                String log = map.containsKey(entry.getKey()) ? map.get(entry.getKey()) + "\n\nScriptTab " + tab + ":\n" + entry.getValue() : " ScriptTab " + tab + ":\n" + entry.getValue();
                map.put(entry.getKey(), log);
            }
        }
        return map;
    }

    @Override
    public void clearConsoleText(Long key) {
        for (ScriptContainer script : this.getScripts()) {
            script.console.remove(key);
        }
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public boolean isClient() {
        return Thread.currentThread().getName().toLowerCase().contains("client");
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return CustomNpcs.EnableScripting && this.enabled && ScriptController.HasStart && !this.scripts.isEmpty();
    }

    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        String pos = "";
        int dimID = 0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double tpY = 0.0;
        if (type != null) {
            TextComponentString hook = new TextComponentString("Hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        IEntityLivingBase<?> iEntity = null;
        IBlock iBlock = null;
        if (event instanceof Event && !(event instanceof CustomNPCsEvent)) {
            event = new ForgeEvent((Event)event);
        }
        if (event instanceof PlayerEvent) {
            if (((PlayerEvent)((Object)event)).player != null) {
                iEntity = ((PlayerEvent)((Object)event)).player;
            } else {
                TextComponentString mesPlayer = new TextComponentString("; Global players script");
                mesPlayer.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
                message = message.func_150257_a((ITextComponent)mesPlayer);
            }
            if (((PlayerEvent)((Object)event)).player != null) {
                iEntity = ((PlayerEvent)((Object)event)).player;
            }
        } else if (event instanceof NpcEvent && ((NpcEvent)((Object)event)).npc != null) {
            iEntity = ((NpcEvent)((Object)event)).npc;
        }
        if (iEntity != null) {
            TextComponentString mesEntity = iEntity.getMCEntity() instanceof EntityPlayer ? new TextComponentString("; Player \"") : (iEntity.getMCEntity() instanceof EntityNPCInterface ? new TextComponentString("; NPC \"") : new TextComponentString("; Entity \""));
            mesEntity.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString name = new TextComponentString(iEntity.getName());
            name.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesUUID = new TextComponentString("\"; UUID: \"");
            mesUUID.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString uuid = new TextComponentString(iEntity.getUUID());
            uuid.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesIn = new TextComponentString("\" in ");
            mesIn.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)mesEntity).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)mesUUID).func_150257_a((ITextComponent)uuid).func_150257_a((ITextComponent)mesIn);
            x = (double)Math.round(iEntity.getPos().getX() * 100.0) / 100.0;
            y = (double)Math.round(iEntity.getPos().getY() * 100.0) / 100.0;
            z = (double)Math.round(iEntity.getPos().getZ() * 100.0) / 100.0;
            dimID = iEntity.getWorld().getMCWorld() == null ? 0 : iEntity.getWorld().getMCWorld().field_73011_w.getDimension();
            pos = "dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z;
        }
        if (event instanceof BlockEvent && ((BlockEvent)((Object)event)).block != null) {
            iBlock = ((BlockEvent)((Object)event)).block;
        }
        if (iBlock != null) {
            TextComponentString mesBlock = new TextComponentString("; Block in ");
            mesBlock.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)mesBlock);
            x = Math.floor(iBlock.getPos().getX());
            y = Math.floor(iBlock.getPos().getY());
            z = Math.floor(iBlock.getPos().getZ());
            dimID = iBlock.getWorld().getMCWorld() == null ? 0 : iBlock.getWorld().getMCWorld().field_73011_w.getDimension();
            pos = "dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z;
            tpY = 1.0;
        }
        if (!pos.isEmpty()) {
            TextComponentString posClick = new TextComponentString(pos);
            posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + (y + tpY) + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
            message = message.func_150257_a((ITextComponent)posClick);
        }
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)side);
    }

    @Override
    public void runScript(String type, Event event) {
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts.clear();
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10), this, false);
        this.scriptLanguage = Util.instance.deleteColor(compound.func_74779_i("ScriptLanguage"));
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public void setLanguage(String language) {
        if (ScriptController.Instance.languages.containsKey(language = Util.instance.deleteColor(language))) {
            this.scriptLanguage = Util.instance.deleteColor(language);
        }
    }

    @Override
    public void setLastInited(long timeMC) {
        this.lastInited = timeMC;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    public boolean isEmpty() {
        for (ScriptContainer cont : this.scripts) {
            if (!cont.hasScriptCode()) continue;
            return false;
        }
        return true;
    }
}

